const mongoose = require("mongoose");
const slugify = require("slugify");

const categorySchema = new mongoose.Schema(
  {
    name: {
      type: String,
      required: [true, "A category must have a name"],
      unique: true,
      trim: true,
    },
    slug: String,
    // 🔥 UPDATED: Icon is now an image file
    icon: {
      type: String,
      default: "default-category.png",
    },
    description: String,
  },
  {
    timestamps: true,
  }
);

// Middleware to create slug from name
categorySchema.pre("save", function (next) {
  if (this.name) {
    this.slug = slugify(this.name, { lower: true });
  }
  next();
});

const Category = mongoose.model("Category", categorySchema);
module.exports = Category;
